/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.FluidTankBlock;
import com.st0x0ef.stellaris.common.menus.FluidTankMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacketWithoutDirection;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends BaseContainerBlockEntity
implements FluidProvider.BLOCK,
TickingBlockEntity {
    private final SingleFluidStorage fluidTank;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private int renderStage = -1;

    public FluidTankBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, ((FluidTankBlock)state.getBlock()).capacity);
    }

    public FluidTankBlockEntity(BlockPos pos, BlockState state, long capacity) {
        super(BlockEntityRegistry.FLUID_TANK.get(), pos, state);
        this.fluidTank = new SingleFluidStorage(capacity){

            @Override
            protected void onChange() {
                FluidTankBlockEntity.this.setChanged();
                if (FluidTankBlockEntity.this.level != null && FluidTankBlockEntity.this.level.getServer() != null && !FluidTankBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FluidTankBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacketWithoutDirection(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FluidTankBlockEntity.this.getBlockPos()));
                }
            }
        };
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.fluidTank.save(tag, registries, "fluid_tank");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fluidTank.load(tag, registries, "fluid_tank");
    }

    @Nullable
    public SingleFluidStorage getFluidTank(@Nullable Direction direction) {
        return this.fluidTank;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    @Override
    public void tick() {
        int initialRenderStage = this.renderStage;
        if (!((ItemStack)this.items.getFirst()).isEmpty()) {
            FluidUtil.moveFluidFromItem(0, 0, this.items, this.fluidTank, 1000L);
        }
        if (!((ItemStack)this.items.getLast()).isEmpty()) {
            FluidUtil.moveFluidToItem(0, this.fluidTank, 1, this.items, 1000L);
        }
        FluidUtil.distributeFluidNearby(this.level, this.worldPosition, this.fluidTank.getFluidInTank(0).copyWithAmount(this.fluidTank.getFluidValueInTank() / 20L));
        this.renderStage = Math.toIntExact(this.fluidTank.getFluidValueInTank() * 9L / this.fluidTank.getTankCapacity(0));
        if (initialRenderStage != this.renderStage) {
            BlockState state = (BlockState)this.getBlockState().setValue((Property)FluidTankBlock.STAGE, (Comparable)Integer.valueOf(this.renderStage));
            this.level.setBlock(this.getBlockPos(), state, 3);
            this.setChanged();
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"screen.stellaris.fluid_tank");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new FluidTankMenu(containerId, inventory, (Container)this, this);
    }

    public int getContainerSize() {
        return 2;
    }

    public SingleFluidStorage getFluidTank() {
        return this.fluidTank;
    }
}

